require_relative '../rspec_helper'
require_relative '../../pages/community_care/community_Care_PageObject'
require 'rubygems'
require 'watir-webdriver'
require_relative '../../module/DriverUtility'



describe '[Story VAR-9231 :Landing Page (unauthenticated/login page) - Add descriptive info regarding app features;
           Story VAR-9473 : Learn About Community Care - Modal and Info Text (Unauthenticated User);
             ]' do

  include DriverUtility

  shared_context "Shared Test" do
  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @cc_po = CommunityCare_PageObject.new(@driver)
    @cc_po_appointments = LandingAppointments.new(@driver)
  end

  after(:all) do
    quitDriver
  end

  end

  context "AC#VAR-9490|TC#VAR-9535: Landing Page (unauthenticated/login page) - Add descriptive info regarding app features" do
    include_context "Shared Test"

    it "verify un-authenticate landing page info" do
      @cc_po.landing.landing_page_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@cc_po.landing.landing_page_title_element.text).to eq("Welcome to VA Appointments")
      expect(@cc_po.landing.text).to eq("The VA Appointment app allows patients to:")
      actual_content = @cc_po.landing.app_allows_list_element.text.split("\n")
      expected_content = [\
      "Schedule appointments for supported types of care directly with the VA facility.",
      "Submit requests to a scheduling clerk for a VA facility appointment.",
      "Submit requests for non VA appointments (Community Care) to a scheduling clerk (distance eligible veterans only)."
      ]
      comp_text(expected_content, actual_content)

    end

    it "verify the Learn About CC Modal content" do
      @cc_po.landingCC.learn_cc
      @cc_po.landingCC.learn_cc_text_element.wait_until_present(TIME_OUT_LIMIT)
      p actual_content = (@cc_po.landingCC.learn_cc_text_element.text).split("\n")

      expected_content = [\
      "Learn About Community Care",
      "The Veterans Choice Program (VCP), part of Community Care, allows Veterans who are already enrolled in VA Healthcare to receive health care in their community, while still having access to their regular VA health care. Under the VCP, Veterans who have to wait more than 30 days or travel over 40 miles are able to receive care in the community, connecting them to timely and convenient access to health care. VCP 40 mile eligible Veterans will now be able to submit scheduling requests directly through the VA Appointments app.",
      "",
      "To learn more information about the Veterans Choice Program and to see if you are eligible visit: https://www.DOMAIN.EX/opa/choiceact/",
      "To access a current list of approved providers, visit: https://www.DOMAIN.EX/opa/apps/locator/index.html",
      "OK"
      ]
      comp_text(expected_content, actual_content)
    end

    it "Verify the external link on Learn CC Modal" do
      @cc_po.landingCC.link_vet_choice
      @cc_po.landingCC.modal_title_element.when_visible(TIME_OUT_LIMIT)
      expect(@cc_po.landingCC.modal_title_element.text).to eq("Confirmation")
      expect(@cc_po.landingCC.modal_content_element.text).to eq("You are about to leave the VA Appointments app. Select CONTINUE to proceed to the link information selected, or select RETURN to return to the VA Appointments app.")
      sleep(4)
      @cc_po.landingCC.modal_return_btn
    end


    def comp_text(expected_content, actual_content)
      expected_content.each_with_index do |expectedScreenRow, i|
        expect(actual_content[i].to_s.strip).to eq(expectedScreenRow.to_s.strip)
      end
      expect(expected_content.size).to eq(actual_content.size)
    end

  end
  end

TT